import json
import textwrap
delimiter = "--------"

def get_instruction(comm_only=False, task="<task>"):
    INSTRUCTION = textwrap.dedent(f"""\
        You are driving a car, and your goal is to accomplish a task {task}.
        You can coordinate with any other vehicles to avoid collisions and or reduce wait time.
        I will give you description of the driving situation from your LiDAR perception, but note that it maybe partially observable.
        The observations are formatted as:
            Observation: <observation>
        """)
    if not comm_only:
        INSTRUCTION += textwrap.dedent("""\
            You have a predefined route to follow, so you just need to adjust your speed and follow the route.
            Only the following commands are available for agents now: 1. stop (slow down the vehicle) 2. go (keep speed and follow the planned route) 3. speed up (accelerate the vehicle)
            """)
    return textwrap.dedent(INSTRUCTION)

def get_common_sense(comm_only=False, control_only=False):
    if control_only:
        COMMON_SENSE = """\
            1. Sign of the Lane ID indicate the direction of the lane.
            2. You decide an action every 10 frames (0.5 seconds).
            3. Do not switch your plan action unless it is necessary.
            """
    else:
        COMMON_SENSE = """\
            1. Sign of the Lane ID indicate the direction of the lane.
            2. You will be provided a message dialog if there is any communication with other vehicles, be sure to analyze those messages.
            3. You decide an action every 10 frames (0.5 seconds).
            4. Do not switch your plan action unless it is necessary.
            """
    return textwrap.dedent(COMMON_SENSE)

def get_cot_prompt_1(comm_only=False, control_only=False):
    if comm_only:
        COT_PROMPT_1 = """\
            Analyze the progress of your task if it involves multiple steps through the observation of the environment.
            Analyze other vehicles in the situation, received messages dialog from other vehicles, analyze their intentions from the message.
            Base on your knowledge and cooperative strategies (if any), think about what are good messages to send to them to accomplish your task safely in time.
            """
    if control_only:
        COT_PROMPT_1 = """\
            Analyze the progress of your task if it involves multiple steps through the observation of the environment.
            Analyze the traffic situation and any other vehicles.
            Based on your knowledge, think about what are good actions to take to accomplish your task safely in time.
            """
    else:
        COT_PROMPT_1 = """\
            Analyze the progress of your task if it involves multiple steps through the observation of the environment.
            Analyze other vehicles in the situation, received messages dialog from other vehicles, analyze their intentions from the message.
            How to react to them or negotiate to accomplish your task safely in time, based on your knowledge and cooperative strategies (if any).
            """
    return textwrap.dedent(COT_PROMPT_1)

def get_cot_prompt_2(comm_only=False, control_only=False):
    if comm_only:
        COT_PROMPT_2 = """\
        Based on your analysis, you need to decide an action to accomplish your task.
        You MUST respond with an action, formatted as a JSON object with the following structure:
        message: <message>
        where you replace <message> with your message to the other vehicles, if any.
        Do nothing else but return the action.
        """
    elif control_only:
        COT_PROMPT_2 = """\
        Based on your analysis, you need to decide an action to accomplish your task.
        You MUST respond with an action, formatted as a JSON object with the following structure:
        command: <command>
        where you replace <command> with your actual command, chossing from: go, stop, speed up
        Do nothing else but return the action.
        """
    else:
        COT_PROMPT_2 = """\
        Based on your analysis, you need to decide an action to accomplish your task.
        You MUST respond with an action, formatted as a JSON object with the following structure:
        command: <command>, message: <message>
        where you replace <command> with your actual command, chossing from: go, stop, speed up
        You should replace <message> with your message to the other vehicles, if any.
        Do nothing else but return the action.
        """

    return textwrap.dedent(COT_PROMPT_2)

def get_few_shot_prompt(few_shot_obs, few_shot_reasoning, few_shot_actions):
    if len(few_shot_obs) == 0:
        return []
    few_shot_prompt = [{"role": "user", "content": "Here are some examples of similar situations you have encountered and your reactions before: "}]
    for i, (obs, reasoning, action) in enumerate(zip(few_shot_obs, few_shot_reasoning, few_shot_actions)):
        obs_message = "Observation: " + obs
        few_shot_prompt.append({"role": "user", "content": obs_message})
        few_shot_prompt.append({"role": "user", "content": get_cot_prompt_1()})
        few_shot_prompt.append({"role": "assistant", "content": reasoning})
        few_shot_prompt.append({"role": "user", "content": get_cot_prompt_2()})
        few_shot_prompt.append({"role": "assistant", "content": action})

    return few_shot_prompt

def test():
    print(get_instruction())
    print(get_common_sense())
    print(get_cot_prompt_1())
    print(get_cot_prompt_2())
    print(get_few_shot_prompt(["observation1", "observation2"], ["answer1", "answer2"], ["action1", "action2"]))

if __name__ == "__main__":
    test()
